import { BUTTON_COLOR, GREYISH_BROWN } from 'constants/colors';

const styles = () => ({
    container: {
        height: 'calc(100% - 93px)',
        '@media (min-width: 961px)': {
            display: 'flex',
            flexDirection: 'column'
        }
    },
    innerContainer: {
        display: 'flex',
        flexDirection: 'column',
        alignItems: 'center',
        width: '100%',
        marginTop: 55,
        '@media (min-width: 961px)': {
            display: 'flex',
            flexDirection: 'column',
            alignItems: 'center',
            justifyContent: 'center',
            width: '100%',
            flex: '1 0 auto',
            marginTop: 0
        }
    },
    imageContainer: {
        width: 167,
        height: 128,
        position: 'relative'
    },
    badgeImage: {
        position: 'absolute',
        right: '-12px',
        bottom: '-12px'
    },
    title: {
        fontFamily: 'Roboto-Condensed',
        fontSize: 22,
        fontWeight: 'bold',
        fontStyle: 'normal',
        lineHeight: 1.27,
        letterSpacing: 0.68,
        textAlign: 'center',
        color: GREYISH_BROWN,
        marginTop: 61
    },
    subtitle: {
        color: GREYISH_BROWN,
        opacity: 0.8,
        fontFamily: 'Lato',
        fontSize: 16,
        fontWeight: 'normal',
        fontStretch: 'normal',
        fontStyle: 'normal',
        lineHeight: 1.5,
        letterSpacing: 'normal',
        textAlign: 'center',
        marginTop: 16,

        '& a': {
            color: BUTTON_COLOR
        }
    }
});

export default styles;
